<?php
/**
 * Plugin Name: WP Stats Counter
 * Plugin URI:  https://your-website.com
 * Description: Zählt Beitragsaufrufe und Datei-Downloads mit Cookie-Schutz und Admin-Dashboard.
 * Version:     1.0.0
 * Author:      Your Name
 * License:     GPL-2.0+
 * Text Domain: wp-stats-counter
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

define( 'WPSC_VERSION',     '1.0.0' );
define( 'WPSC_PLUGIN_DIR',  plugin_dir_path( __FILE__ ) );
define( 'WPSC_PLUGIN_URL',  plugin_dir_url( __FILE__ ) );
define( 'WPSC_COOKIE_DAYS', 1 ); // Cookie-Gültigkeit in Tagen

// ──────────────────────────────────────────────
// Activation / Deactivation / Uninstall
// ──────────────────────────────────────────────
require_once WPSC_PLUGIN_DIR . 'includes/class-installer.php';
register_activation_hook(   __FILE__, array( 'WPSC_Installer', 'activate' ) );
register_deactivation_hook( __FILE__, array( 'WPSC_Installer', 'deactivate' ) );

// ──────────────────────────────────────────────
// Core includes
// ──────────────────────────────────────────────
require_once WPSC_PLUGIN_DIR . 'includes/class-post-views.php';
require_once WPSC_PLUGIN_DIR . 'includes/class-download-tracker.php';
require_once WPSC_PLUGIN_DIR . 'includes/class-frontend.php';
require_once WPSC_PLUGIN_DIR . 'admin/class-admin.php';

// ──────────────────────────────────────────────
// Bootstrap
// ──────────────────────────────────────────────
add_action( 'plugins_loaded', function () {
    new WPSC_Post_Views();
    new WPSC_Download_Tracker();
    new WPSC_Frontend();
    if ( is_admin() ) {
        new WPSC_Admin();
    }
} );
