/* WP Stats Counter – Frontend JS */
(function ($) {
    'use strict';

    if (typeof wpscData === 'undefined') return;

    var ajaxUrl = wpscData.ajaxUrl;
    var nonce   = wpscData.nonce;
    var postId  = wpscData.postId;

    // ── Beitragsaufruf zählen ─────────────────────────────────────────
    function trackView() {
        $.post(ajaxUrl, {
            action:  'wpsc_track_view',
            nonce:   nonce,
            post_id: postId,
        }, function (res) {
            if (res.success) {
                var $counter = $('.wpsc-view-count');
                if ($counter.length) {
                    // Zahl animiert aktualisieren
                    var newCount = parseInt(res.data.count, 10);
                    animateCount($counter, newCount);
                }
            }
        });
    }

    function animateCount($el, target) {
        var current = parseInt($el.text().replace(/\D/g, ''), 10) || 0;
        if (current === target) return;
        var step = target > current ? 1 : -1;
        var speed = Math.max(10, Math.floor(200 / Math.abs(target - current)));
        var interval = setInterval(function () {
            current += step;
            $el.text(current.toLocaleString('de-DE'));
            if (current === target) clearInterval(interval);
        }, speed);
    }

    // ── Download-Badges initialisieren ────────────────────────────────
    function initDownloadBadges() {
        $('[data-wpsc-download="1"]').each(function () {
            var $link     = $(this);
            var url       = $link.data('wpsc-url');
            var postIdDl  = $link.data('wpsc-post') || postId;
            var fileName  = $link.data('wpsc-file') || '';

            // Badge einfügen (Loading-Zustand)
            var $badge = $('<span>', {
                'class': 'wpsc-download-badge wpsc-download-badge--loading',
                html: '<span class="wpsc-download-badge__icon">⬇</span> ' +
                      '<span class="wpsc-download-badge__count">…</span>'
            });

            $link.after($badge);

            // Aktuellen Count laden (ohne zu zählen → GET wäre sauberer,
            // aber wir nutzen einfach den AJAX-Endpoint mit Cookie-Schutz)
            loadDownloadCount(url, $badge);

            // Click: Download zählen
            $link.on('click.wpsc', function () {
                trackDownload(url, postIdDl, fileName, $badge);
            });
        });
    }

    function loadDownloadCount(url, $badge) {
        // Wir schicken eine "Probe-Anfrage" – wenn Cookie gesetzt ist,
        // gibt der Server den aktuellen Stand zurück ohne zu zählen.
        // Wenn kein Cookie → nur anzeigen, Zählung erst beim Klick.
        // Wir nutzen einen eigenen AJAX-Action für reines Lesen:
        $.post(ajaxUrl, {
            action:   'wpsc_get_download_count',
            nonce:    nonce,
            url:      url,
        }, function (res) {
            if (res.success) {
                updateBadge($badge, res.data.count);
            } else {
                updateBadge($badge, 0);
            }
        }).fail(function () {
            $badge.hide();
        });
    }

    function trackDownload(url, postIdDl, fileName, $badge) {
        $.post(ajaxUrl, {
            action:    'wpsc_track_download',
            nonce:     nonce,
            url:       url,
            post_id:   postIdDl,
            file_name: fileName,
        }, function (res) {
            if (res.success) {
                updateBadge($badge, res.data.count);
            }
        });
    }

    function updateBadge($badge, count) {
        $badge.removeClass('wpsc-download-badge--loading');
        $badge.find('.wpsc-download-badge__count').text(
            parseInt(count, 10).toLocaleString('de-DE') + 'x'
        );
        $badge.attr('title', count + ' Downloads');
    }

    // ── Init ──────────────────────────────────────────────────────────
    $(document).ready(function () {
        if (postId) {
            trackView();
        }
        initDownloadBadges();
    });

})(jQuery);
