<?php
if ( ! defined( 'ABSPATH' ) ) exit;

class WPSC_Post_Views {

    public function __construct() {
        add_action( 'wp_ajax_wpsc_track_view',        array( $this, 'ajax_track_view' ) );
        add_action( 'wp_ajax_nopriv_wpsc_track_view', array( $this, 'ajax_track_view' ) );
    }

    // ── AJAX: Aufruf zählen ───────────────────────────────────────────
    public function ajax_track_view() {
        check_ajax_referer( 'wpsc_nonce', 'nonce' );

        $post_id = isset( $_POST['post_id'] ) ? absint( $_POST['post_id'] ) : 0;
        if ( ! $post_id ) {
            wp_send_json_error( 'Invalid post ID' );
        }

        // Cookie-Schutz: Bereits gezählt?
        $cookie_name = 'wpsc_view_' . $post_id;
        if ( isset( $_COOKIE[ $cookie_name ] ) ) {
            $count = self::get_views( $post_id );
            wp_send_json_success( array( 'count' => $count, 'cached' => true ) );
        }

        // Zähler erhöhen
        $count = self::increment_views( $post_id );

        // Cookie setzen (läuft nach X Tagen ab)
        $expires = time() + ( absint( get_option( 'wpsc_cookie_days', 1 ) ) * DAY_IN_SECONDS );
        setcookie( $cookie_name, '1', $expires, COOKIEPATH, COOKIE_DOMAIN, is_ssl(), true );

        wp_send_json_success( array( 'count' => $count, 'cached' => false ) );
    }

    // ── Views für einen Beitrag abrufen ───────────────────────────────
    public static function get_views( $post_id ) {
        global $wpdb;
        $table = $wpdb->prefix . 'wpsc_post_views';
        $count = $wpdb->get_var(
            $wpdb->prepare( "SELECT view_count FROM {$table} WHERE post_id = %d", $post_id )
        );
        return $count ? absint( $count ) : 0;
    }

    // ── Views erhöhen ─────────────────────────────────────────────────
    public static function increment_views( $post_id ) {
        global $wpdb;
        $table = $wpdb->prefix . 'wpsc_post_views';

        $wpdb->query(
            $wpdb->prepare(
                "INSERT INTO {$table} (post_id, view_count)
                 VALUES (%d, 1)
                 ON DUPLICATE KEY UPDATE view_count = view_count + 1",
                $post_id
            )
        );

        return self::get_views( $post_id );
    }

    // ── Top-Beiträge für Dashboard ────────────────────────────────────
    public static function get_top_posts( $limit = 20 ) {
        global $wpdb;
        $table = $wpdb->prefix . 'wpsc_post_views';
        return $wpdb->get_results(
            $wpdb->prepare(
                "SELECT v.post_id, v.view_count, v.last_view, p.post_title
                 FROM {$table} v
                 LEFT JOIN {$wpdb->posts} p ON p.ID = v.post_id
                 ORDER BY v.view_count DESC
                 LIMIT %d",
                $limit
            )
        );
    }

    // ── Gesamt-Views ──────────────────────────────────────────────────
    public static function get_total_views() {
        global $wpdb;
        $table = $wpdb->prefix . 'wpsc_post_views';
        return (int) $wpdb->get_var( "SELECT SUM(view_count) FROM {$table}" );
    }
}
