<?php
if ( ! defined( 'ABSPATH' ) ) exit;

class WPSC_Installer {

    public static function activate() {
        global $wpdb;
        $charset = $wpdb->get_charset_collate();

        // ── Tabelle: Beitragsaufrufe ──────────────────────────────────
        $views_table = $wpdb->prefix . 'wpsc_post_views';
        $sql_views = "CREATE TABLE {$views_table} (
            id         BIGINT(20) UNSIGNED NOT NULL AUTO_INCREMENT,
            post_id    BIGINT(20) UNSIGNED NOT NULL,
            view_count BIGINT(20) UNSIGNED NOT NULL DEFAULT 0,
            last_view  DATETIME            NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
            PRIMARY KEY  (id),
            UNIQUE KEY   post_id (post_id)
        ) {$charset};";

        // ── Tabelle: Downloads ────────────────────────────────────────
        $dl_table = $wpdb->prefix . 'wpsc_downloads';
        $sql_dl = "CREATE TABLE {$dl_table} (
            id             BIGINT(20) UNSIGNED NOT NULL AUTO_INCREMENT,
            post_id        BIGINT(20) UNSIGNED NOT NULL DEFAULT 0,
            file_url       TEXT                NOT NULL,
            file_name      VARCHAR(255)        NOT NULL DEFAULT '',
            download_count BIGINT(20) UNSIGNED NOT NULL DEFAULT 0,
            last_download  DATETIME            NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
            PRIMARY KEY (id),
            KEY post_id (post_id)
        ) {$charset};";

        require_once ABSPATH . 'wp-admin/includes/upgrade.php';
        dbDelta( $sql_views );
        dbDelta( $sql_dl );

        add_option( 'wpsc_version', WPSC_VERSION );
        add_option( 'wpsc_cookie_days', WPSC_COOKIE_DAYS );
    }

    public static function deactivate() {
        // Nichts löschen beim Deaktivieren
    }

    /**
     * Vollständig deinstallieren – wird aus uninstall.php aufgerufen.
     * Löscht alle Tabellen UND Plugin-Optionen.
     */
    public static function uninstall() {
        global $wpdb;

        $wpdb->query( "DROP TABLE IF EXISTS {$wpdb->prefix}wpsc_post_views" );
        $wpdb->query( "DROP TABLE IF EXISTS {$wpdb->prefix}wpsc_downloads" );

        delete_option( 'wpsc_version' );
        delete_option( 'wpsc_cookie_days' );
    }
}
