<?php
if ( ! defined( 'ABSPATH' ) ) exit;

class WPSC_Frontend {

    public function __construct() {
        add_action( 'wp_enqueue_scripts', array( $this, 'enqueue_assets' ) );
        add_filter( 'the_content',        array( $this, 'append_view_counter' ), 99 );
    }

    // ── Assets ────────────────────────────────────────────────────────
    public function enqueue_assets() {
        if ( ! is_singular() ) return;

        wp_enqueue_style(
            'wpsc-frontend',
            WPSC_PLUGIN_URL . 'public/css/wpsc-frontend.css',
            array(),
            WPSC_VERSION
        );

        wp_enqueue_script(
            'wpsc-frontend',
            WPSC_PLUGIN_URL . 'public/js/wpsc-frontend.js',
            array( 'jquery' ),
            WPSC_VERSION,
            true
        );

        wp_localize_script( 'wpsc-frontend', 'wpscData', array(
            'ajaxUrl' => admin_url( 'admin-ajax.php' ),
            'nonce'   => wp_create_nonce( 'wpsc_nonce' ),
            'postId'  => get_the_ID(),
            'i18n'    => array(
                'views'     => __( 'Aufrufe', 'wp-stats-counter' ),
                'downloads' => __( 'Downloads', 'wp-stats-counter' ),
                'times'     => __( 'mal', 'wp-stats-counter' ),
            ),
        ) );
    }

    // ── Aufrufe-Zähler unter dem Beitrag ─────────────────────────────
    public function append_view_counter( $content ) {
        if ( ! is_singular() || ! in_the_loop() || ! is_main_query() ) {
            return $content;
        }

        $post_id = get_the_ID();
        $count   = WPSC_Post_Views::get_views( $post_id );

        $html  = '<div class="wpsc-view-counter" data-post-id="' . esc_attr( $post_id ) . '">';
        $html .= '<span class="wpsc-counter-icon">👁</span> ';
        $html .= '<span class="wpsc-counter-label">' . esc_html__( 'Dieser Artikel wurde', 'wp-stats-counter' ) . ' ';
        $html .= '<span class="wpsc-view-count">' . number_format_i18n( $count ) . '</span> ';
        $html .= esc_html__( 'mal gelesen', 'wp-stats-counter' ) . '</span>';
        $html .= '</div>';

        return $content . $html;
    }
}
