<?php if ( ! defined( 'ABSPATH' ) ) exit; ?>
<div class="wrap wpsc-wrap">

    <h1 class="wpsc-page-title">
        <span class="wpsc-logo">⚙️</span>
        Stats Counter – Einstellungen
    </h1>

    <?php if ( isset( $_GET['reset'] ) ) : ?>
    <div class="notice notice-success is-dismissible">
        <p>Daten wurden erfolgreich zurückgesetzt.</p>
    </div>
    <?php endif; ?>

    <!-- Einstellungen -->
    <div class="wpsc-settings-grid">

        <div class="wpsc-settings-box">
            <h2>Cookie-Einstellungen</h2>
            <p>Legt fest, wie lange ein Besucher nicht erneut gezählt wird (Cookie-Laufzeit).</p>

            <form method="post" action="">
                <?php wp_nonce_field( 'wpsc_settings' ); ?>
                <table class="form-table">
                    <tr>
                        <th scope="row">
                            <label for="wpsc_cookie_days">Cookie-Gültigkeit (Tage)</label>
                        </th>
                        <td>
                            <input
                                type="number"
                                id="wpsc_cookie_days"
                                name="wpsc_cookie_days"
                                value="<?php echo esc_attr( $cookie_days ); ?>"
                                min="1"
                                max="365"
                                class="small-text"
                            />
                            <p class="description">
                                Empfehlung: <strong>1 Tag</strong>. Ein Besucher wird erst nach Ablauf dieser Zeit wieder gezählt.
                            </p>
                        </td>
                    </tr>
                </table>
                <p class="submit">
                    <button type="submit" name="wpsc_save_settings" class="button button-primary">
                        💾 Einstellungen speichern
                    </button>
                </p>
            </form>
        </div>

        <!-- Daten zurücksetzen -->
        <div class="wpsc-settings-box wpsc-settings-box--danger">
            <h2>⚠️ Daten zurücksetzen</h2>
            <p>Achtung: Diese Aktionen können <strong>nicht rückgängig</strong> gemacht werden!</p>

            <div class="wpsc-reset-buttons">
                <a href="<?php echo wp_nonce_url( admin_url('admin-post.php?action=wpsc_reset&type=views'), 'wpsc_reset' ); ?>"
                   class="button wpsc-btn-reset"
                   onclick="return confirm('Wirklich alle Aufruf-Statistiken löschen?')">
                    🗑 Alle Aufrufe löschen
                </a>

                <a href="<?php echo wp_nonce_url( admin_url('admin-post.php?action=wpsc_reset&type=downloads'), 'wpsc_reset' ); ?>"
                   class="button wpsc-btn-reset"
                   onclick="return confirm('Wirklich alle Download-Statistiken löschen?')">
                    🗑 Alle Downloads löschen
                </a>

                <a href="<?php echo wp_nonce_url( admin_url('admin-post.php?action=wpsc_reset&type=all'), 'wpsc_reset' ); ?>"
                   class="button wpsc-btn-reset wpsc-btn-reset--all"
                   onclick="return confirm('Wirklich ALLE Statistiken löschen?')">
                    💥 Alle Daten löschen
                </a>
            </div>
        </div>

    </div><!-- .wpsc-settings-grid -->

    <!-- Info Box -->
    <div class="wpsc-info-box">
        <h3>ℹ️ Wie funktioniert das Plugin?</h3>
        <ul>
            <li><strong>Beitragsaufrufe:</strong> Wird automatisch unter jedem Einzelbeitrag angezeigt. Jeder Besucher wird durch ein Cookie für <?php echo esc_html( $cookie_days ); ?> Tag(e) nur einmal gezählt.</li>
            <li><strong>Download-Tracking:</strong> Alle Links im Beitrags-Inhalt werden automatisch erkannt – egal ob interne Dateien (.zip, .pdf, .exe, ...) oder externe URLs. Jeder Besucher wird pro Datei nur einmal gezählt.</li>
            <li><strong>Deinstallation:</strong> Beim Löschen des Plugins werden alle Tabellen und Optionen vollständig aus der Datenbank entfernt.</li>
        </ul>
    </div>

</div><!-- .wpsc-wrap -->
