<?php if ( ! defined( 'ABSPATH' ) ) exit; ?>
<div class="wrap wpsc-wrap">

    <h1 class="wpsc-page-title">
        <span class="wpsc-logo">📊</span>
        Stats Counter – Dashboard
    </h1>

    <!-- KPI Cards -->
    <div class="wpsc-cards">
        <div class="wpsc-card wpsc-card--blue">
            <div class="wpsc-card__icon">👁</div>
            <div class="wpsc-card__body">
                <div class="wpsc-card__number"><?php echo number_format_i18n( $total_views ); ?></div>
                <div class="wpsc-card__label">Gesamt-Aufrufe</div>
            </div>
        </div>
        <div class="wpsc-card wpsc-card--green">
            <div class="wpsc-card__icon">⬇</div>
            <div class="wpsc-card__body">
                <div class="wpsc-card__number"><?php echo number_format_i18n( $total_dl ); ?></div>
                <div class="wpsc-card__label">Gesamt-Downloads</div>
            </div>
        </div>
        <div class="wpsc-card wpsc-card--purple">
            <div class="wpsc-card__icon">📝</div>
            <div class="wpsc-card__body">
                <div class="wpsc-card__number"><?php echo count( $top_posts ); ?></div>
                <div class="wpsc-card__label">Beiträge mit Aufrufen</div>
            </div>
        </div>
        <div class="wpsc-card wpsc-card--orange">
            <div class="wpsc-card__icon">📁</div>
            <div class="wpsc-card__body">
                <div class="wpsc-card__number"><?php echo count( $top_downloads ); ?></div>
                <div class="wpsc-card__label">Getrackte Dateien</div>
            </div>
        </div>
    </div>

    <!-- Charts Row -->
    <?php if ( ! empty( $top_posts ) || ! empty( $top_downloads ) ) : ?>
    <div class="wpsc-charts-row">
        <?php if ( ! empty( $top_posts ) ) : ?>
        <div class="wpsc-chart-box">
            <h2>Top 10 – Meist gelesene Beiträge</h2>
            <div class="wpsc-chart-wrapper">
                <canvas id="wpscViewsChart"></canvas>
            </div>
        </div>
        <?php endif; ?>
        <?php if ( ! empty( $top_downloads ) ) : ?>
        <div class="wpsc-chart-box">
            <h2>Top 10 – Meistgeladene Dateien</h2>
            <div class="wpsc-chart-wrapper">
                <canvas id="wpscDownloadsChart"></canvas>
            </div>
        </div>
        <?php endif; ?>
    </div>
    <?php endif; ?>

    <div class="wpsc-tables-row">

        <!-- Beitragsaufrufe Tabelle -->
        <div class="wpsc-table-box">
            <h2>📄 Beitragsaufrufe <span class="wpsc-badge"><?php echo count( $top_posts ); ?></span></h2>
            <?php if ( empty( $top_posts ) ) : ?>
                <p class="wpsc-empty">Noch keine Aufrufe erfasst.</p>
            <?php else : ?>
            <table class="widefat wpsc-table">
                <thead>
                    <tr>
                        <th>#</th>
                        <th>Beitrag</th>
                        <th>Aufrufe</th>
                        <th>Letzter Aufruf</th>
                        <th></th>
                    </tr>
                </thead>
                <tbody>
                <?php foreach ( $top_posts as $i => $row ) : ?>
                    <tr>
                        <td class="wpsc-rank"><?php echo $i + 1; ?></td>
                        <td class="wpsc-post-title">
                            <?php echo esc_html( $row->post_title ?: '(Beitrag #' . $row->post_id . ')' ); ?>
                        </td>
                        <td>
                            <span class="wpsc-count-badge wpsc-count-badge--blue">
                                <?php echo number_format_i18n( $row->view_count ); ?>
                            </span>
                        </td>
                        <td class="wpsc-date"><?php echo esc_html( date_i18n( 'd.m.Y H:i', strtotime( $row->last_view ) ) ); ?></td>
                        <td>
                            <a href="<?php echo esc_url( get_permalink( $row->post_id ) ); ?>" target="_blank" class="button button-small">Ansehen</a>
                        </td>
                    </tr>
                <?php endforeach; ?>
                </tbody>
            </table>
            <?php endif; ?>
        </div>

        <!-- Downloads Tabelle -->
        <div class="wpsc-table-box">
            <h2>⬇ Downloads <span class="wpsc-badge"><?php echo count( $top_downloads ); ?></span></h2>
            <?php if ( empty( $top_downloads ) ) : ?>
                <p class="wpsc-empty">Noch keine Downloads erfasst.</p>
            <?php else : ?>
            <table class="widefat wpsc-table">
                <thead>
                    <tr>
                        <th>#</th>
                        <th>Datei</th>
                        <th>Beitrag</th>
                        <th>Downloads</th>
                        <th>Letzter Download</th>
                    </tr>
                </thead>
                <tbody>
                <?php foreach ( $top_downloads as $i => $row ) : ?>
                    <tr>
                        <td class="wpsc-rank"><?php echo $i + 1; ?></td>
                        <td class="wpsc-file-name">
                            <a href="<?php echo esc_url( $row->file_url ); ?>" target="_blank" title="<?php echo esc_attr( $row->file_url ); ?>">
                                <?php echo esc_html( $row->file_name ?: basename( parse_url( $row->file_url, PHP_URL_PATH ) ) ); ?>
                            </a>
                        </td>
                        <td class="wpsc-post-title">
                            <?php echo esc_html( $row->post_title ?: '—' ); ?>
                        </td>
                        <td>
                            <span class="wpsc-count-badge wpsc-count-badge--green">
                                <?php echo number_format_i18n( $row->download_count ); ?>
                            </span>
                        </td>
                        <td class="wpsc-date"><?php echo esc_html( date_i18n( 'd.m.Y H:i', strtotime( $row->last_download ) ) ); ?></td>
                    </tr>
                <?php endforeach; ?>
                </tbody>
            </table>
            <?php endif; ?>
        </div>

    </div><!-- .wpsc-tables-row -->
</div><!-- .wpsc-wrap -->

<!-- Chart.js Data -->
<?php if ( ! empty( $top_posts ) ) : ?>
<script id="wpsc-views-data" type="application/json">
<?php
$chart_posts = array_slice( $top_posts, 0, 10 );
echo json_encode( array(
    'labels' => array_map( function($r) { return $r->post_title ? ( mb_strlen($r->post_title) > 30 ? mb_substr($r->post_title,0,30).'…' : $r->post_title ) : 'Post #'.$r->post_id; }, $chart_posts ),
    'data'   => array_map( function($r) { return (int) $r->view_count; }, $chart_posts ),
) );
?>
</script>
<?php endif; ?>

<?php if ( ! empty( $top_downloads ) ) : ?>
<script id="wpsc-downloads-data" type="application/json">
<?php
$chart_dl = array_slice( $top_downloads, 0, 10 );
echo json_encode( array(
    'labels' => array_map( function($r) { $n = $r->file_name ?: basename(parse_url($r->file_url, PHP_URL_PATH)); return mb_strlen($n) > 30 ? mb_substr($n,0,30).'…' : $n; }, $chart_dl ),
    'data'   => array_map( function($r) { return (int) $r->download_count; }, $chart_dl ),
) );
?>
</script>
<?php endif; ?>
