/* WP Stats Counter – Admin JS */
(function () {
    'use strict';

    document.addEventListener('DOMContentLoaded', function () {
        renderChart('wpscViewsChart', 'wpsc-views-data', '#2271b1', '#dde8f3');
        renderChart('wpscDownloadsChart', 'wpsc-downloads-data', '#00a32a', '#d7f0dd');
    });

    function renderChart(canvasId, dataScriptId, borderColor, bgColor) {
        var canvas = document.getElementById(canvasId);
        var dataEl = document.getElementById(dataScriptId);
        if (!canvas || !dataEl) return;

        var data;
        try {
            data = JSON.parse(dataEl.textContent);
        } catch (e) {
            return;
        }

        new Chart(canvas, {
            type: 'bar',
            data: {
                labels: data.labels,
                datasets: [{
                    data: data.data,
                    backgroundColor: bgColor,
                    borderColor: borderColor,
                    borderWidth: 2,
                    borderRadius: 6,
                    maxBarThickness: 48,  // Balken nie breiter als 48px
                    minBarLength: 4,      // Auch Wert=1 sichtbar
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                plugins: {
                    legend: { display: false },
                    tooltip: {
                        callbacks: {
                            label: function(ctx) {
                                return ' ' + ctx.parsed.y.toLocaleString('de-DE');
                            }
                        }
                    }
                },
                scales: {
                    y: {
                        beginAtZero: true,
                        ticks: {
                            precision: 0,
                            color: '#646970',
                            maxTicksLimit: 6,
                        },
                        grid: { color: '#f0f0f1' },
                    },
                    x: {
                        ticks: {
                            color: '#1d2327',
                            maxRotation: 35,
                            font: { size: 11 },
                        },
                        grid: { display: false },
                    }
                }
            }
        });
    }
})();
