<?php
if ( ! defined( 'ABSPATH' ) ) exit;

class WPSC_Admin {

    public function __construct() {
        add_action( 'admin_menu',             array( $this, 'register_menu' ) );
        add_action( 'admin_enqueue_scripts',  array( $this, 'enqueue_assets' ) );
        add_action( 'admin_post_wpsc_reset',  array( $this, 'handle_reset' ) );
    }

    // ── Menü ──────────────────────────────────────────────────────────
    public function register_menu() {
        add_menu_page(
            __( 'Stats Counter', 'wp-stats-counter' ),
            __( 'Stats Counter', 'wp-stats-counter' ),
            'manage_options',
            'wpsc-dashboard',
            array( $this, 'render_dashboard' ),
            'dashicons-chart-bar',
            30
        );

        add_submenu_page(
            'wpsc-dashboard',
            __( 'Dashboard', 'wp-stats-counter' ),
            __( 'Dashboard', 'wp-stats-counter' ),
            'manage_options',
            'wpsc-dashboard',
            array( $this, 'render_dashboard' )
        );

        add_submenu_page(
            'wpsc-dashboard',
            __( 'Einstellungen', 'wp-stats-counter' ),
            __( 'Einstellungen', 'wp-stats-counter' ),
            'manage_options',
            'wpsc-settings',
            array( $this, 'render_settings' )
        );
    }

    // ── Admin Assets ──────────────────────────────────────────────────
    public function enqueue_assets( $hook ) {
        if ( strpos( $hook, 'wpsc' ) === false ) return;

        wp_enqueue_style(
            'wpsc-admin',
            WPSC_PLUGIN_URL . 'admin/css/wpsc-admin.css',
            array(),
            WPSC_VERSION
        );

        wp_enqueue_script(
            'wpsc-admin-charts',
            'https://cdn.jsdelivr.net/npm/chart.js@4.4.0/dist/chart.umd.min.js',
            array(),
            '4.4.0',
            true
        );

        wp_enqueue_script(
            'wpsc-admin',
            WPSC_PLUGIN_URL . 'admin/js/wpsc-admin.js',
            array( 'wpsc-admin-charts' ),
            WPSC_VERSION,
            true
        );
    }

    // ── Dashboard ─────────────────────────────────────────────────────
    public function render_dashboard() {
        $top_posts     = WPSC_Post_Views::get_top_posts( 25 );
        $top_downloads = WPSC_Download_Tracker::get_top_downloads( 25 );
        $total_views   = WPSC_Post_Views::get_total_views();
        $total_dl      = WPSC_Download_Tracker::get_total_downloads();
        include WPSC_PLUGIN_DIR . 'admin/views/dashboard.php';
    }

    // ── Einstellungen ─────────────────────────────────────────────────
    public function render_settings() {
        if ( isset( $_POST['wpsc_save_settings'] ) && check_admin_referer( 'wpsc_settings' ) ) {
            $days = absint( $_POST['wpsc_cookie_days'] );
            update_option( 'wpsc_cookie_days', max( 1, $days ) );
            echo '<div class="notice notice-success is-dismissible"><p>' . esc_html__( 'Einstellungen gespeichert.', 'wp-stats-counter' ) . '</p></div>';
        }
        $cookie_days = get_option( 'wpsc_cookie_days', 1 );
        include WPSC_PLUGIN_DIR . 'admin/views/settings.php';
    }

    // ── Reset ─────────────────────────────────────────────────────────
    public function handle_reset() {
        if ( ! current_user_can( 'manage_options' ) ) wp_die( 'Unauthorized' );
        check_admin_referer( 'wpsc_reset' );

        $type = isset( $_GET['type'] ) ? sanitize_key( $_GET['type'] ) : '';
        global $wpdb;

        if ( $type === 'views' ) {
            $wpdb->query( "TRUNCATE TABLE {$wpdb->prefix}wpsc_post_views" );
        } elseif ( $type === 'downloads' ) {
            $wpdb->query( "TRUNCATE TABLE {$wpdb->prefix}wpsc_downloads" );
        } elseif ( $type === 'all' ) {
            $wpdb->query( "TRUNCATE TABLE {$wpdb->prefix}wpsc_post_views" );
            $wpdb->query( "TRUNCATE TABLE {$wpdb->prefix}wpsc_downloads" );
        }

        wp_redirect( admin_url( 'admin.php?page=wpsc-settings&reset=1' ) );
        exit;
    }
}
