<?php
if ( ! defined( 'ABSPATH' ) ) exit;

class AutoSEO_DB {

    public static function install() {
        global $wpdb;
        $charset_collate = $wpdb->get_charset_collate();
        $table = $wpdb->prefix . 'autoseo_log';

        $sql = "CREATE TABLE IF NOT EXISTS $table (
            id BIGINT(20) UNSIGNED NOT NULL AUTO_INCREMENT,
            post_id BIGINT(20) UNSIGNED NOT NULL,
            post_title TEXT NOT NULL,
            action VARCHAR(50) NOT NULL DEFAULT 'manual',
            seo_title TEXT,
            seo_description TEXT,
            focus_keyphrase TEXT,
            status VARCHAR(20) NOT NULL DEFAULT 'success',
            error_message TEXT,
            created_at DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
            PRIMARY KEY (id),
            KEY post_id (post_id)
        ) $charset_collate;";

        require_once( ABSPATH . 'wp-admin/includes/upgrade.php' );
        dbDelta( $sql );

        add_option( 'autoseo_language',     'de' );
        add_option( 'autoseo_auto_on_save', '1' );
        add_option( 'autoseo_post_types',   array( 'post', 'page' ) );
        add_option( 'autoseo_overwrite',    '0' );
        add_option( 'autoseo_version',      AUTOSEO_VERSION );
    }

    public static function deactivate() {
        wp_clear_scheduled_hook( 'autoseo_cron_scan' );
    }

    public static function uninstall() {
        global $wpdb;
        // Tabelle löschen
        $wpdb->query( "DROP TABLE IF EXISTS " . $wpdb->prefix . "autoseo_log" );

        // Alle Optionen löschen
        foreach ( array(
            'autoseo_language', 'autoseo_auto_on_save',
            'autoseo_post_types', 'autoseo_overwrite', 'autoseo_version'
        ) as $opt ) {
            delete_option( $opt );
        }
        wp_clear_scheduled_hook( 'autoseo_cron_scan' );
    }

    public static function log( $post_id, $post_title, $action, $data = array(), $status = 'success', $error = '' ) {
        global $wpdb;
        $wpdb->insert(
            $wpdb->prefix . 'autoseo_log',
            array(
                'post_id'         => $post_id,
                'post_title'      => $post_title,
                'action'          => $action,
                'seo_title'       => $data['seo_title']       ?? '',
                'seo_description' => $data['seo_description'] ?? '',
                'focus_keyphrase' => $data['focus_keyphrase'] ?? '',
                'status'          => $status,
                'error_message'   => $error,
                'created_at'      => current_time( 'mysql' ),
            ),
            array( '%d', '%s', '%s', '%s', '%s', '%s', '%s', '%s', '%s' )
        );
    }

    public static function get_logs( $limit = 100 ) {
        global $wpdb;
        return $wpdb->get_results(
            "SELECT * FROM {$wpdb->prefix}autoseo_log ORDER BY created_at DESC LIMIT " . intval( $limit )
        );
    }

    public static function clear_logs() {
        global $wpdb;
        $wpdb->query( "TRUNCATE TABLE {$wpdb->prefix}autoseo_log" );
    }
}
