<?php
if ( ! defined( 'ABSPATH' ) ) exit;

class AutoSEO_Admin {

    public function init() {
        add_action( 'admin_menu',            array( $this, 'add_menu' ) );
        add_action( 'admin_enqueue_scripts', array( $this, 'enqueue' ) );
        add_action( 'admin_init',            array( $this, 'register_settings' ) );
    }

    public function add_menu() {
        add_menu_page( 'Auto SEO Pro', 'Auto SEO Pro', 'manage_options',
            'auto-seo-pro', array( $this, 'render_dashboard' ), 'dashicons-chart-line', 80 );
        add_submenu_page( 'auto-seo-pro', 'Dashboard', 'Dashboard', 'manage_options',
            'auto-seo-pro', array( $this, 'render_dashboard' ) );
        add_submenu_page( 'auto-seo-pro', 'Einstellungen', 'Einstellungen', 'manage_options',
            'auto-seo-settings', array( $this, 'render_settings' ) );
        add_submenu_page( 'auto-seo-pro', 'Protokoll', 'Protokoll', 'manage_options',
            'auto-seo-log', array( $this, 'render_log' ) );
    }

    public function enqueue( $hook ) {
        if ( strpos( $hook, 'auto-seo' ) === false ) return;
        wp_enqueue_style(  'auto-seo-pro', AUTOSEO_PLUGIN_URL . 'admin/css/admin.css', array(), AUTOSEO_VERSION );
        wp_enqueue_script( 'auto-seo-pro', AUTOSEO_PLUGIN_URL . 'admin/js/admin.js', array( 'jquery' ), AUTOSEO_VERSION, true );
        wp_localize_script( 'auto-seo-pro', 'AutoSEO', array(
            'ajax_url' => admin_url( 'admin-ajax.php' ),
            'nonce'    => wp_create_nonce( 'autoseo_nonce' ),
        ) );
    }

    public function register_settings() {
        register_setting( 'autoseo_settings', 'autoseo_language',     'sanitize_text_field' );
        register_setting( 'autoseo_settings', 'autoseo_auto_on_save', 'sanitize_text_field' );
        register_setting( 'autoseo_settings', 'autoseo_overwrite',    'sanitize_text_field' );
        register_setting( 'autoseo_settings', 'autoseo_post_types' );
    }

    public function render_dashboard() {
        $site = get_bloginfo( 'name' );
        $url  = get_bloginfo( 'url' );
        ?>
        <div class="wrap autoseo-wrap">
            <div class="autoseo-header">
                <div>
                    <h1>⚡ Auto SEO Pro</h1>
                    <p>Automatische Yoast SEO Felder für <strong><?php echo esc_html( $site ); ?></strong>
                    <span class="autoseo-domain"><?php echo esc_html( $url ); ?></span></p>
                </div>
                <div class="autoseo-version">v<?php echo AUTOSEO_VERSION; ?></div>
            </div>

            <div class="autoseo-stats">
                <div class="autoseo-stat-card">
                    <div class="autoseo-stat-number" id="stat-total">–</div>
                    <div class="autoseo-stat-label">Beiträge gesamt</div>
                </div>
                <div class="autoseo-stat-card autoseo-red">
                    <div class="autoseo-stat-number" id="stat-missing">–</div>
                    <div class="autoseo-stat-label">SEO fehlt</div>
                </div>
                <div class="autoseo-stat-card autoseo-green">
                    <div class="autoseo-stat-number" id="stat-complete">–</div>
                    <div class="autoseo-stat-label">Vollständig</div>
                </div>
                <div class="autoseo-stat-card autoseo-blue">
                    <div class="autoseo-stat-number" id="stat-percent">–</div>
                    <div class="autoseo-stat-label">Optimiert %</div>
                </div>
            </div>

            <div class="autoseo-actions">
                <button id="btn-scan"        class="autoseo-btn autoseo-btn-secondary">🔍 Scannen</button>
                <button id="btn-process-all" class="autoseo-btn autoseo-btn-primary">⚡ Alle fehlenden ausfüllen</button>
            </div>

            <div id="autoseo-progress" style="display:none">
                <div class="autoseo-progress-bar"><div class="autoseo-progress-fill" id="progress-fill"></div></div>
                <div class="autoseo-progress-text" id="progress-text"></div>
            </div>

            <div id="autoseo-results" style="display:none">
                <h2>✅ Gerade verarbeitet</h2>
                <div id="autoseo-results-list"></div>
            </div>

            <div id="autoseo-missing-list" style="display:none">
                <h2>📋 Beiträge mit fehlenden SEO-Feldern</h2>
                <table class="autoseo-table wp-list-table widefat fixed striped">
                    <thead><tr>
                        <th>Beitrag</th><th style="width:80px">Typ</th>
                        <th>Fehlende Felder</th><th style="width:150px">Aktion</th>
                    </tr></thead>
                    <tbody id="missing-tbody"></tbody>
                </table>
            </div>
        </div>
        <?php
    }

    public function render_settings() {
        if ( isset( $_POST['autoseo_submit'] ) && check_admin_referer( 'autoseo_save_settings' ) ) {
            update_option( 'autoseo_language',     sanitize_text_field( $_POST['autoseo_language']     ?? 'de' ) );
            update_option( 'autoseo_auto_on_save', isset( $_POST['autoseo_auto_on_save'] ) ? '1' : '0' );
            update_option( 'autoseo_overwrite',    isset( $_POST['autoseo_overwrite'] )    ? '1' : '0' );
            $types = array_map( 'sanitize_text_field', (array)( $_POST['autoseo_post_types'] ?? array() ) );
            update_option( 'autoseo_post_types', $types );
            echo '<div class="notice notice-success is-dismissible"><p>✅ Einstellungen gespeichert!</p></div>';
        }

        $lang      = get_option( 'autoseo_language',     'de' );
        $auto_save = get_option( 'autoseo_auto_on_save', '1' );
        $overwrite = get_option( 'autoseo_overwrite',    '0' );
        $types     = get_option( 'autoseo_post_types',   array( 'post', 'page' ) );
        ?>
        <div class="wrap autoseo-wrap">
            <div class="autoseo-header">
                <div><h1>⚙️ Auto SEO Pro – Einstellungen</h1>
                <p>Konfiguration für <strong><?php echo esc_html( get_bloginfo('name') ); ?></strong></p></div>
            </div>

            <form method="post">
                <?php wp_nonce_field( 'autoseo_save_settings' ); ?>

                <div class="autoseo-card">
                    <h2>🌍 Allgemein</h2>
                    <table class="form-table">
                        <tr>
                            <th scope="row">Sprache der SEO-Texte</th>
                            <td>
                                <select name="autoseo_language">
                                    <option value="de" <?php selected( $lang, 'de' ); ?>>🇩🇪 Deutsch</option>
                                    <option value="en" <?php selected( $lang, 'en' ); ?>>🇬🇧 Englisch</option>
                                </select>
                                <p class="description">Stopwörter und Call-to-Actions werden entsprechend angepasst.</p>
                            </td>
                        </tr>
                        <tr>
                            <th scope="row">Beitragstypen</th>
                            <td>
                                <?php foreach ( get_post_types( array( 'public' => true ), 'objects' ) as $t ) : ?>
                                <label style="display:block;margin-bottom:6px;">
                                    <input type="checkbox" name="autoseo_post_types[]"
                                        value="<?php echo esc_attr( $t->name ); ?>"
                                        <?php checked( in_array( $t->name, $types ) ); ?> />
                                    <strong><?php echo esc_html( $t->label ); ?></strong>
                                    <span style="color:#999">(<?php echo esc_html( $t->name ); ?>)</span>
                                </label>
                                <?php endforeach; ?>
                            </td>
                        </tr>
                    </table>
                </div>

                <div class="autoseo-card">
                    <h2>🤖 Automatisierung</h2>
                    <table class="form-table">
                        <tr>
                            <th scope="row">Beim Speichern</th>
                            <td>
                                <label>
                                    <input type="checkbox" name="autoseo_auto_on_save" value="1" <?php checked( $auto_save, '1' ); ?> />
                                    SEO-Felder automatisch ausfüllen wenn ein Beitrag veröffentlicht wird
                                </label>
                            </td>
                        </tr>
                        <tr>
                            <th scope="row">Bestehende überschreiben</th>
                            <td>
                                <label>
                                    <input type="checkbox" name="autoseo_overwrite" value="1" <?php checked( $overwrite, '1' ); ?> />
                                    Bereits vorhandene Yoast SEO Felder überschreiben
                                </label>
                                <p class="description">⚠️ Vorsicht: aktiviere dies nur wenn du alle SEO-Texte neu generieren möchtest.</p>
                            </td>
                        </tr>
                    </table>
                </div>

                <p class="submit">
                    <input type="submit" name="autoseo_submit" class="button-primary" value="💾 Einstellungen speichern" />
                </p>
            </form>
        </div>
        <?php
    }

    public function render_log() {
        $logs = AutoSEO_DB::get_logs( 100 );
        ?>
        <div class="wrap autoseo-wrap">
            <div class="autoseo-header">
                <div><h1>📋 Auto SEO Pro – Protokoll</h1>
                <p>Letzte 100 Einträge für <strong><?php echo esc_html( get_bloginfo('name') ); ?></strong></p></div>
                <button id="btn-clear-log" class="autoseo-btn autoseo-btn-danger">🗑️ Löschen</button>
            </div>
            <?php if ( empty( $logs ) ) : ?>
                <div class="autoseo-notice">Noch keine Einträge vorhanden.</div>
            <?php else : ?>
            <table class="autoseo-table wp-list-table widefat fixed striped">
                <thead><tr>
                    <th style="width:120px">Datum</th><th>Beitrag</th>
                    <th style="width:85px">Aktion</th><th style="width:65px">Status</th>
                    <th>SEO-Titel</th><th>Beschreibung</th><th>Keyphrase</th>
                </tr></thead>
                <tbody>
                <?php foreach ( $logs as $l ) : ?>
                <tr>
                    <td><?php echo esc_html( date( 'd.m.y H:i', strtotime( $l->created_at ) ) ); ?></td>
                    <td><a href="<?php echo esc_url( get_edit_post_link( $l->post_id ) ); ?>" target="_blank"><?php echo esc_html( $l->post_title ); ?></a></td>
                    <td><span class="autoseo-badge autoseo-badge-info"><?php echo esc_html( $l->action ); ?></span></td>
                    <td><?php echo $l->status === 'success'
                        ? '<span class="autoseo-badge autoseo-badge-ok">✅</span>'
                        : '<span class="autoseo-badge autoseo-badge-err" title="' . esc_attr( $l->error_message ) . '">❌</span>'; ?>
                    </td>
                    <td><?php echo esc_html( $l->seo_title ); ?></td>
                    <td><?php echo esc_html( $l->seo_description ); ?></td>
                    <td><?php echo esc_html( $l->focus_keyphrase ); ?></td>
                </tr>
                <?php endforeach; ?>
                </tbody>
            </table>
            <?php endif; ?>
        </div>
        <?php
    }
}
