<?php
/**
 * Plugin Name: Auto SEO Pro
 * Plugin URI: https://github.com/auto-seo-pro
 * Description: Automatische Yoast SEO Felder (Titel, Meta-Beschreibung, Fokus-Keyphrase) – regelbasiert, kostenlos, kein API-Key nötig. Funktioniert auf jeder WordPress-Seite.
 * Version: 1.0.0
 * Author: Auto SEO Pro
 * License: GPL2
 * Text Domain: auto-seo-pro
 */

if ( ! defined( 'ABSPATH' ) ) exit;

define( 'AUTOSEO_VERSION',    '1.0.0' );
define( 'AUTOSEO_PLUGIN_DIR', plugin_dir_path( __FILE__ ) );
define( 'AUTOSEO_PLUGIN_URL', plugin_dir_url( __FILE__ ) );

require_once AUTOSEO_PLUGIN_DIR . 'includes/class-autoseo-db.php';
require_once AUTOSEO_PLUGIN_DIR . 'includes/class-autoseo-generator.php';
require_once AUTOSEO_PLUGIN_DIR . 'includes/class-autoseo-processor.php';
require_once AUTOSEO_PLUGIN_DIR . 'includes/class-autoseo-admin.php';

register_activation_hook( __FILE__, array( 'AutoSEO_DB', 'install' ) );
register_deactivation_hook( __FILE__, array( 'AutoSEO_DB', 'deactivate' ) );
register_uninstall_hook( __FILE__, array( 'AutoSEO_DB', 'uninstall' ) );

function auto_seo_pro_init() {
    $admin     = new AutoSEO_Admin();
    $admin->init();
    $processor = new AutoSEO_Processor();
    $processor->init();
}
add_action( 'plugins_loaded', 'auto_seo_pro_init' );
