/* Auto SEO Pro – Admin JS */
(function($){
    'use strict';

    var totalMissing = 0, processed = 0, isRunning = false;

    // Beim Laden automatisch scannen
    if ($('#btn-scan').length) {
        setTimeout(function(){ $('#btn-scan').trigger('click'); }, 300);
    }

    // SCAN
    $('#btn-scan').on('click', function(){
        var $b = $(this).prop('disabled', true).text('⏳ Scanne...');
        $('#autoseo-missing-list').hide();
        $('#stat-total,#stat-missing,#stat-complete,#stat-percent').text('...');

        $.post(AutoSEO.ajax_url, { action:'autoseo_get_missing', nonce:AutoSEO.nonce }, function(r){
            $b.prop('disabled', false).text('🔍 Scannen');
            if (!r.success) { alert('Fehler: ' + r.data); return; }
            var d = r.data;
            $('#stat-total').text(d.total);
            $('#stat-missing').text(d.missing_count);
            $('#stat-complete').text(d.complete_count);
            var pct = d.total > 0 ? Math.round((d.complete_count / d.total) * 100) : 100;
            $('#stat-percent').text(pct + '%');
            totalMissing = d.missing_count;

            if (d.missing.length > 0) {
                buildTable(d.missing);
                $('#autoseo-missing-list').show();
            } else {
                $('#autoseo-missing-list').hide();
                if (d.total > 0) alert('🎉 Alle Beiträge haben vollständige SEO-Felder!');
            }
        }).fail(function(){ $b.prop('disabled',false).text('🔍 Scannen'); alert('Verbindungsfehler.'); });
    });

    // Tabelle bauen
    function buildTable(posts){
        var html = '';
        $.each(posts, function(i, p){
            html += '<tr id="row-'+p.id+'">';
            html += '<td><strong>'+esc(p.title)+'</strong></td>';
            html += '<td><span class="autoseo-badge autoseo-badge-info">'+esc(p.type)+'</span></td>';
            html += '<td>'+p.missing_fields.map(function(f){ return '<span class="autoseo-badge autoseo-badge-err">'+esc(f)+'</span>'; }).join(' ')+'</td>';
            html += '<td><button class="autoseo-btn autoseo-btn-primary autoseo-btn-small btn-single" data-id="'+p.id+'">⚡ Ausfüllen</button></td>';
            html += '</tr>';
        });
        $('#missing-tbody').html(html);
    }

    // Einzeln ausfüllen
    $(document).on('click', '.btn-single', function(){
        var $b = $(this).prop('disabled',true).text('⏳...');
        var id = $b.data('id');
        $.post(AutoSEO.ajax_url, { action:'autoseo_process_single', nonce:AutoSEO.nonce, post_id:id }, function(r){
            if (!r.success){ $b.prop('disabled',false).text('⚡ Ausfüllen'); alert('Fehler: '+r.data); return; }
            $('#row-'+id+' td:nth-child(3)').html('<span class="autoseo-badge autoseo-badge-ok">✅ Fertig</span>');
            $b.prop('disabled',true).text('✅');
            updateCounters(-1);
        }).fail(function(){ $b.prop('disabled',false).text('⚡ Ausfüllen'); });
    });

    // Alle ausfüllen
    $('#btn-process-all').on('click', function(){
        if (isRunning) return;
        if (!confirm('Alle Beiträge mit fehlenden SEO-Feldern werden jetzt automatisch ausgefüllt. Fortfahren?')) return;
        isRunning = true; processed = 0;
        $(this).prop('disabled',true).text('⏳ Läuft...');
        $('#btn-scan').prop('disabled',true);
        $('#autoseo-progress').show();
        $('#autoseo-results').show();
        $('#autoseo-results-list').html('');
        setProgress(0, 'Starte...');
        runBatch(0);
    });

    function runBatch(offset){
        $.post(AutoSEO.ajax_url, { action:'autoseo_process_all', nonce:AutoSEO.nonce, offset:offset }, function(r){
            if (!r.success){ finish('❌ Fehler: '+r.data); return; }
            var d = r.data;
            processed += d.processed;

            $.each(d.results || [], function(i, item){
                var html = '<div class="autoseo-result">';
                html += '<div class="autoseo-result-title">✅ '+esc(item.title)+'</div>';
                html += '<div class="autoseo-result-meta">';
                html += '<b>Titel:</b> '+esc(item.data.seo_title)+'<br>';
                html += '<b>Beschreibung:</b> '+esc(item.data.seo_description)+'<br>';
                html += '<b>Keyphrase:</b> '+esc(item.data.focus_keyphrase);
                html += '</div></div>';
                $('#autoseo-results-list').prepend(html);
            });

            var pct = totalMissing > 0 ? Math.min(100, Math.round((processed/totalMissing)*100)) : 100;
            setProgress(pct, processed+' verarbeitet, '+d.skipped+' übersprungen');

            if (d.done) { finish('✅ Fertig! '+processed+' Beiträge optimiert.'); }
            else { setTimeout(function(){ runBatch(d.next_offset); }, 500); }
        }).fail(function(){ finish('❌ Verbindungsfehler.'); });
    }

    function finish(msg){
        isRunning = false;
        setProgress(100, msg);
        $('#btn-process-all').prop('disabled',false).text('⚡ Alle fehlenden ausfüllen');
        $('#btn-scan').prop('disabled',false);
        setTimeout(function(){ $('#btn-scan').trigger('click'); }, 1000);
    }

    function setProgress(pct, txt){
        $('#progress-fill').css('width', pct+'%');
        $('#progress-text').text(txt);
    }

    function updateCounters(delta){
        var m = parseInt($('#stat-missing').text()) + delta;
        var c = parseInt($('#stat-complete').text()) - delta;
        var t = parseInt($('#stat-total').text()) || 0;
        $('#stat-missing').text(Math.max(0,m));
        $('#stat-complete').text(Math.max(0,c));
        if (t > 0) $('#stat-percent').text(Math.round((Math.max(0,c)/t)*100)+'%');
    }

    // Log löschen
    $('#btn-clear-log').on('click', function(){
        if (!confirm('Protokoll wirklich löschen?')) return;
        $.post(AutoSEO.ajax_url, { action:'autoseo_clear_log', nonce:AutoSEO.nonce }, function(r){
            if (r.success) location.reload();
        });
    });

    function esc(s){
        if (!s) return '';
        return String(s).replace(/&/g,'&amp;').replace(/</g,'&lt;').replace(/>/g,'&gt;').replace(/"/g,'&quot;');
    }

})(jQuery);
